/* 
Statistik 1 (HzE-Statistik) ab Berichtsjahr 2023
*/


select 

/* Allgemeine Daten zum Vorgang und zur Aktion */

      v.bereich as "Bereich", 
      v.aktenzeichen as "Aktenzeichen",
      isnull(u.name,'') as "Sachbearbeiter",
      a.nachname as "Nachname JM",
      a.vorname as "Vorname JM",
      convert(char(10),p.geburtsdatum,104) as "GebDatum JM",
      convert(char(10),m.vondatum,104) as "Aktionsbeginn",
      isnull(convert(char(10),m.bisdatum,104),'') as "Aktionsende",

      right(replicate('0',5) + cast(s.statbogenlfdnr as varchar(5)),5) as "Lfd Nr (nach bergabe)",
      right(replicate('0',20) + cast(s.kennnummerjm as varchar(20)),20) as "Kennnummer JM",

      case s.mehrereeinzelhilfe
           when 1 then 'ja'
           when 2 then 'nein'
           else '(Angabe fehlt)'
       end as "Mehrere Hilfen Meldezeitpkt",

       s.lfdnrakteinzelhilf as "Lfd Nr der Hilfe",

       isnull(s.ags,'') as " 28 Wohnort AGS",
       isnull(s.plz,'') as " 28 PLZ",
       isnull(s.wohnort,'') as " 28 Wohnort",


/* Abschnitt A - Beginn der Hilfegewhrung (Aktionsbeginn) */

      s.berichtsjahr as "Berichtsjahr", 
      cast((case when month(m.vondatum) < 10 then '0' else '' end) as varchar) + cast(month(m.vondatum) as varchar) as "Monat Hilfebeginn", 
      cast(year(m.vondatum) as char(4)) as "Jahr Hilfebeginn",

      case s.hilfebeginnuebja
           when '1' then 'ja'
           else 'nein'
      end as "bern von anderem JugAmt",
      
      case s.gefaehrdungseinsch
           when '1' then 'ja'
           when '2' then 'nein'
           else '(Angabe fehlt)'
      end as "Vorh GefEinschtzung",
       
      case s.schutzmassnahmeneu
           when 1 then 'aufgrund unbegleitete Einreise'
           when 2 then 'aufgrund dringender Kiwo-Gefhrdung'
           when 3 then 'aufgrund Bitte JM um ION'
           when 4 then 'keine vorherige ION'
           else '(Angabe fehlt)'
      end as "Anschlusshilfe nach ION",       

/* Abschnitt B - Art der Hilfe */

      case s.artderhilfe
           when '01' then ' 28 SGB VIII Erziehungsberatung vorrangig mit der Familie (Eltern und Kind)'
           when '02' then ' 28 SGB VIII Erziehungsberatung vorrangig mit den Eltern (zusammen oder einzeln)'
           when '03' then ' 28 SGB VIII Erziehungsberatung vorrangig mit dem jungen Menschen'
           when '04' then ' 29 SGB VIII Soziale Gruppenarbeit'
           when '05' then ' 30 SGB VIII Erziehungsbeistandschaft'
           when '06' then ' 30 SGB VIII Betreuungshelfer'
           when '07' then ' 31 SGB VIII Sozialpdagogische Familienhilfe'
           when '08' then ' 32 SGB VIII Erziehung in einer Tagesgruppe'
           when '09' then ' 33 SGB VIII Vollzeitpflege (allgemein gem Satz 1)'
           when '10' then ' 33 SGB VIII Vollzeitpflege (besondere Pflegeformen fr entwicklungsbeeintrchtigte junge Menschen gem Satz 2)'
           when '11' then ' 34 SGB VIII Heimerziehung, sonstige betreute Wohnform'
           when '12' then ' 35 SGB VIII Intensive sozialpdagogische Einzelbetreuung'
           when '13' then ' 35a SGB VIII Eingliederungshilfe fr seelisch behinderte junge Menschen'
           when '14' then ' 27 SGB VIII Hilfe zur Erziehung, vorrangig ambulant/teilstationr (ohne Verbindung zu Hilfen gem  28-35 SGB VIII)'
           when '15' then ' 27 SGB VIII Hilfe zur Erziehung, vorrangig auerhalb der Familie (ohne Verbindung zu Hilfen gem  28-35 SGB VIII)'
           when '16' then ' 27 SGB VIII Hilfe zur Erziehung, ergnzende bzw. sonstige Hilfen (ohne Verbindung zu Hilfen gem  28-35 SGB VIII)'
           else '(Angabe fehlt)'
      end as "Art der Hilfe",

/* Abschnitt C - (Hauptschlicher) Ort der Durchfhrung der Hilfegewhrung */

      case s.ortdurchfuehrung
           when '01' then 'In der Wohnung der Herkunftsfamilien/Adoptivfamilie (des jungen Menschen)'
           when '02' then 'In (der Wohnung) einer Verwandtenfamilie'
           when '03' then 'In einer nicht-verwandten Familie (privater Haushalt)'
           when '04' then 'In einer Einrichtung der Kindertagesbetreuung'
           when '05' then 'In der Schule'
           when '06' then 'In den Rumen eines ambulanten Dienstes/einer Beratungsstelle'
           when '07' then 'In einer Einrichtung ber Tag'
           when '08' then 'In einer Mehrgruppen-Einrichtung ber Tag und Nacht'
           when '09' then 'In einer Ein-Gruppen-Einrichtung (auch Auenwohngruppe) ber Tag und Nacht'
           when '10' then 'In der Wohnung des jungen Menschen'
           when '11' then 'Auerhalb von Deutschland'
           when '12' then 'Sonstiger Ort (z.B. JVA, Klinik, Frauenhaus)'
           when '13' then 'Per Telefon'
           when '14' then 'ber das Internet (z.B. Chatberatung, Videokonferenz)'
           else '(Angabe fehlt)'
      end as "Ort der Durchfhrung",

/* Abschnitt D - Trger der Einrichtung oder des Dienstes, von dem die Hilfe/Beratung durchgefhrt wird */

      case s.traegereinricht
           when '10' then 'Trger der ffentlichen Jugendhilfe'
           when '21' then 'Arbeiterwohlfahrt oder deren Mitgliedsorganisation'
           when '22' then 'Deutscher Parittischer Wohlfahrtsverband oder dessen Mitgliedsorganisation'
           when '23' then 'Deutsches Rotes Kreuz oder dessen Mitgliedsorganisation'
           when '24' then 'Diakonisches Werk oder sonstiger der EKD angeschlossener Trger'
           when '25' then 'Deutscher Caritasverband oder sonstiger katholischer Trger'
           when '26' then 'Zentralwohlfahrtsstelle der Juden in Deutschland oder jdische Kultusgemeinde'
           when '27' then 'Sonstige Religionsgemeinschaft des ffentlichen Rechts'
           when '28' then 'Sonstiger anerkannter Trger der Jugendhilfe'
           when '29' then 'Sonstige juristische Person, andere Vereinigung'
           when '30' then 'Wirtschaftsunternehmen (privat-gewerblich)'
           when '40' then 'Pflegefamilie, die Vollzeitpflege gem  33 SGB VIII durchfhrt'
           else '(Angabe fehlt)'
      end as "Trger der Einrichtung",

/* Abschnitt E - Geschlecht und Geburstmonat/-jahr familienorientierte Hilfe */
      case s.familienhilfeneu
           when 1 then 'ja'
           when 2 then 'nein'
           else '(Angabe fehlt)'
       end as "Familienorientierte Hilfe",

      case s.jmgeschlecht 
           when '1' then 'mnnlich'
           when '2' then 'weiblich'
           when '3' then 'divers'
           when '7' then 'ohne Angabe (nach Geburtenregister)'
           else '(Angabe fehlt)'
      end as "Geschlecht JM",

      isnull(s.jmgeburtsmonat,'(Angabe fehlt)') as "Geburtsmonat JM",
      isnull(s.jmgeburtsjahr,'(Angabe fehlt)') as "Geburtsjahr JM",

      isnull(case s.kind01geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 01 Geschlecht",

      isnull(s.kind01gebmonat,'') as "Kind 01 GebMonat",
      isnull(s.kind01gebjahr,'')  as "Kind 01 GebJahr",

      isnull(case s.kind02geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 02 Geschlecht",

      isnull(s.kind02gebmonat,'') as "Kind 02 GebMonat",
      isnull(s.kind02gebjahr,'')  as "Kind 02 GebJahr",

      isnull(case s.kind03geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 03 Geschlecht",

      isnull(s.kind03gebmonat,'') as "Kind 03 GebMonat",
      isnull(s.kind03gebjahr,'')  as "Kind 03 GebJahr",

      isnull(case s.kind04geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 04 Geschlecht",

      isnull(s.kind04gebmonat,'') as "Kind 04 GebMonat",
      isnull(s.kind04gebjahr,'')  as "Kind 04 GebJahr",

      isnull(case s.kind05geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 05 Geschlecht",

      isnull(s.kind05gebmonat,'') as "Kind 05 GebMonat",
      isnull(s.kind05gebjahr,'')  as "Kind 05 GebJahr",

      isnull(case s.kind06geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 06 Geschlecht",

      isnull(s.kind06gebmonat,'') as "Kind 06 GebMonat",
      isnull(s.kind06gebjahr,'')  as "Kind 06 GebJahr",

      isnull(case s.kind07geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 07 Geschlecht",

      isnull(s.kind07gebmonat,'') as "Kind 07 GebMonat",
      isnull(s.kind07gebjahr,'')  as "Kind 07 GebJahr",

      isnull(case s.kind08geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 08 Geschlecht",

      isnull(s.kind08gebmonat,'') as "Kind 08 GebMonat",
      isnull(s.kind08gebjahr,'')  as "Kind 08 GebJahr",

      isnull(case s.kind09geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 09 Geschlecht",

      isnull(s.kind09gebmonat,'') as "Kind 09 GebMonat",
      isnull(s.kind09gebjahr,'')  as "Kind 09 GebJahr",

      isnull(case s.kind10geschlecht
          when '1' then 'mnnlich'
          when '2' then 'weiblich'
          when '3' then 'divers'
          when '7' then 'ohne Angabe (nach Geburtenregister)'
      end,'') as "Kind 10 Geschlecht",

      isnull(s.kind10gebmonat,'') as "Kind 10 GebMonat",
      isnull(s.kind10gebjahr,'')  as "Kind 10 GebJahr",


      isnull(s.zahlminderjausserh,'') as "Zahl MDJ auerhalb",

/* Abschnitt F - Lebenssituation des jungen Menschen bei Beginn der Hilfe */

      case s.aufenthilfebeginn
           when '01' then 'im Haushalt der Eltern/eines Elternteils'
           when '02' then 'bei Verwandten'
           when '03' then 'bei einer sonstigen Person (auch Pflegestelle nach  44 SGB VIII)'
           when '04' then 'in einer eigenen Wohnung/Wohngemeinschaft'
           when '05' then 'in einer Pflegefamilie ( 33, 35a, 41 SGB VIII)'
           when '06' then 'in einem Heim/einer sonstigen betreuten Wohnform ( 34, 35a, 41 SGB VIII)'
           when '07' then 'in einer Psychiatrie'
           when '08' then 'in einer sozialpdagogisch betreuten Einrichtung (z.B. Internat, Mutter-/Vater-Kind-Einrichtung)'
           when '09' then 'in einer anderen Einrichtung'
           when '10' then 'ohne feste Unterkunft'
           when '11' then 'unbekannt/keine Angabe mglich'
           else '(Angabe fehlt)'
      end as "Aufenth vor Hilfe",

      case s.sitherkunftsfam
           when '1' then 'Eltern leben zusammen'
           when '2' then 'Elternteil lebt alleine ohne (Ehe-)Partner/-in'
           when '3' then 'Elternteil lebt mit neuer Partnerin/neuem Partner (z.B. Stiefelternkonstellation)'
           when '4' then 'Eltern sind verstorben'
           when '5' then 'Unbekannt'
           else '(Angabe fehlt)'
      end as "Situation HerkFamilie",

      case s.auslaendherkunft
           when '1' then 'ja'
           when '2' then 'nein'
           else '(Angabe fehlt)'
      end as "Ausl Herkunft Eltern",

      case s.vorrangigdeutsch 
           when '1' then 'deutsch'
           when '2' then 'Nicht deutsch'
           else '(Angabe fehlt)'
      end as "Vorr Sprache Familie",

      case s.wirtschftlsituat
           when '1' then 'ja'
           when '2' then 'nein'
           else '(Angabe fehlt)'
      end as "Sozialleistg HerkFamilie",

/* Abschnitt G - Schulbesuch und Ausbildungsverhltnis / Hinweisgeber */

         case s.hilfeausserhalbelt
                  when 1 then 'ja'
                  when 2 then 'nein'
                  else '(Angabe fehlt)'
         end as "Hilfe auerh Elternhaus",

         case s.aktuelleschuleausb
                  when '01' then 'Grundschule'
                  when '02' then 'Frder- oder Sonderschule'
                  when '03' then 'Schule mit mehreren Bildungsgngen'
                  when '04' then 'Hauptschule'
                  when '05' then 'Realschule'
                  when '06' then 'Gymnasium'
                  when '07' then 'Berufliches, auch Wirtschafts- oder technisches Gymnasium'
                  when '08' then 'Berufliche Schule, die einen allgemeinen Schulabschluss vermittelt'
                  when '09' then 'Sonstige berufliche Schule/Ausbildungssttte'
                  when '10' then 'Hochschule'
                  when '11' then 'Kein Besuch einer Schule/Ausbildungssttte/Hochschule'
                  else '(Angabe fehlt)'
         end as "Aktuelle Schule/AusbSttte",


      case s.hilfeanregende
           when '1' then 'Junger Mensch selbst'
           when '2' then 'Eltern bzw. Personensorgeberechtigte/-r'
           when '3' then 'Schule/Kindertageseinrichtung'
           when '4' then 'Sozialer Dienst/andere Institution (z.B. Jugendamt)'
           when '5' then 'Gericht/Staatsanwaltschaft/Polizei'
           when '6' then 'Arzt/Klinik/Gesundheitsamt'
           when '7' then 'Ehemalige Klienten/Bekannte/Verwandte'
           when '8' then 'Sonstige'
           else '(Angabe fehlt)'
      end as "Hilfe angeregt durch",

/* Abschnitt H - Familien- und vormundschaftsrichterliche Entscheidungen im Zusammenhang mit der Hilfe */

      case s.entzugeltrlsorge
           when '1' then 'Ja'
           when '2' then 'Nein'
           else '(Angabe fehlt)'
      end as "Entzug elt Sorge",

      case s.verfahrensausstz 
           when '1' then 'Ja'
           when '2' then 'Nein'
           else '(Angabe fehlt)'
      end as "Verfahrensaussetzung",

      case s.freiheitsentzug 
           when '1' then 'Ja'
           when '2' then 'Nein'
           else '(Angabe fehlt)'
      end as "Freiheitsentzug",

/* Abschnitt I - Hilfe/Beratung dauert am Jahresende an */

      case s.hilfedauertjahrese
           when '1' then 'Ja'
           when '2' then 'Nein'
           else '(Angabe fehlt)'
      end as "Hilfe dauert an",
      
/* Abschnitt J - Intensitt der am Jahresende andauernden Hilfe/Beratung */

      isnull(s.anzahlberatungen,'') as "BeratKontakte  28 ",
      isnull(s.stundenwochen1,'') as "Wochenstd  29-31,41",

      isnull(case s.stundenwochen2 
           when '1' then 'bis zu 5 Tage pro Woche'
           when '2' then '6-7 Tage pro Woche'
      end,'') as "Leistungstage Woche",

/* Abschnitt K - Grnde fr die Hilfegewhrung */

      case s.hilfehauptgrund
           when '10' then 'Unversorgtheit des jungen Menschen'
           when '11' then 'Unzureichende Frderung/Betreuung/Versorgung des jungen Menschen in der Familie'
           when '12' then 'Gefhrdung des Kindeswohls'
           when '13' then 'Eingeschrnkte Erziehungskompetenz der Eltern/Personensorgeberechtigten'       
           when '14' then 'Belastungen des jungen Menschen durch Problemlagen der Eltern'
           when '15' then 'Belastungen des jungen Menschen durch familire Konflikte'
           when '16' then 'Aufflligkeiten im sozialen Verhalten (dissoziales Verhalten) des jungen Menschen'
           when '17' then 'Entwicklungsaufflligkeiten/seelische Probleme des jungen Menschen'
           when '18' then 'Schulische/Berufliche Probleme des jungen Menschen'
           when '19' then 'bernahme von einem anderen Jugendamt wegen Zustndigkeitswechsels'
           else '(Angabe fehlt)'
      end as "Hauptgrund Hilfe",

      isnull(case s.hilfegrund2
           when '10' then 'Unversorgtheit des jungen Menschen'
           when '11' then 'Unzureichende Frderung/Betreuung/Versorgung des jungen Menschen in der Familie'
           when '12' then 'Gefhrdung des Kindeswohls'
           when '13' then 'Eingeschrnkte Erziehungskompetenz der Eltern/Personensorgeberechtigten'       
           when '14' then 'Belastungen des jungen Menschen durch Problemlagen der Eltern'
           when '15' then 'Belastungen des jungen Menschen durch familire Konflikte'
           when '16' then 'Aufflligkeiten im sozialen Verhalten (dissoziales Verhalten) des jungen Menschen'
           when '17' then 'Entwicklungsaufflligkeiten/seelische Probleme des jungen Menschen'
           when '18' then 'Schulische/Berufliche Probleme des jungen Menschen'
      end,'') as "Hilfegrund 2",

      isnull(case s.hilfegrund3
           when '10' then 'Unversorgtheit des jungen Menschen'
           when '11' then 'Unzureichende Frderung/Betreuung/Versorgung des jungen Menschen in der Familie'
           when '12' then 'Gefhrdung des Kindeswohls'
           when '13' then 'Eingeschrnkte Erziehungskompetenz der Eltern/Personensorgeberechtigten'       
           when '14' then 'Belastungen des jungen Menschen durch Problemlagen der Eltern'
           when '15' then 'Belastungen des jungen Menschen durch familire Konflikte'
           when '16' then 'Aufflligkeiten im sozialen Verhalten (dissoziales Verhalten) des jungen Menschen'
           when '17' then 'Entwicklungsaufflligkeiten/seelische Probleme des jungen Menschen'
           when '18' then 'Schulische/Berufliche Probleme des jungen Menschen'
      end,'') as "Hilfegrund 3",

/* Abschnitt L - Ende der Hilfe/Beratung */

      isnull((case when month(m.bisdatum) < 10 then '0' else '' end) + cast(month(m.bisdatum) as varchar),'') as "Monat Hilfeende", 
      isnull(cast (year(m.bisdatum) as char(4)),'') as "Jahr Hilfeende",


/* Abschnitt M - Betreuungsintensitt der beendeten Hilfe/Beratung */

      isnull(s.endehilfekontake,'') as "Gesamtzahl Kontakte",

      isnull(case s.kontakte6monate
           when '1' then 'ja'
           when '2' then 'nein'
      end,'') as "LetztKontakt 6 Mon",
      
      s.endehilfestdwch1 as "Wochenstd beend Hilfe",

      isnull(case s.endehilfestdwch2
           when '1' then 'bis zu 5 Tage pro Woche'
           when '2' then '6-7 Tage pro Woche'
      end,'') as "Leistungstage beend Hilfe",

/* Abschnitt N - Grund fr die Beendigung der Hilfe/Beratung */

      isnull(case s.beendigungsgrund
           when '10' then 'gem Hilfeplan/Beratungszielen'
           when '20' then 'abweichend von Hilfeplan/Beratungszielen durch den Sorgeberechtigten/den jungen Volljhrigen (auch unzur. Mitwirkg.)'
           when '21' then 'abweichend von Hilfeplan/Beratungszielen durch die bisher betreuende Einrichtung, die Pflegefamilie, den Dienst'
           when '22' then 'abweichend von Hilfeplan/Beratungszielen durch den Minderjhrigen'
           when '30' then 'Adoptionspflege/Adoption'
           when '40' then 'Abgabe an ein anderes Jugendamt wegen Zustndigkeitswechsels'
           when '50' then 'Sonstige Grnde'
       end,'') as "Beendigungsgrund",

/* Abschnitt O - Anschlieender Aufenthalt */

      isnull(case s.anschliessaufent
           when '01' then 'im Haushalt der Eltern/eines Elternteils'
           when '02' then 'bei Verwandten'
           when '03' then 'bei einer sonstigen Person (auch Pflegestelle nach  44 SGB VIII)'
           when '04' then 'in einer eigenen Wohnung/Wohngemeinschaft'
           when '05' then 'in einer Pflegefamilie ( 33, 35a, 41 SGB VIII)'
           when '06' then 'in einem Heim/einer sonstigen betreuten Wohnform ( 34, 35a, 41 SGB VIII)'
           when '07' then 'in einer Psychiatrie'
           when '08' then 'in einer sozialpdagogisch betreuten Einrichtung (z.B. Internat, Mutter-/Vater-Kind-Einrichtung)'
           when '09' then 'in einer anderen Einrichtung'
           when '10' then 'ohne feste Unterkunft'
           when '11' then 'unbekannt/keine Angabe mglich'
      end,'') as "Anschl Aufenthalt",
      
/* Abschnitt P - Unmittelbar nachfolgende Hilfe */

      isnull(case s.folgendehilfe
           when '1' then 'Zustndigkeitswechsel: Hilfe wird in derselben Pflegefamilie/Einrichtung nach Zustndigkeitswechsel fortgefhrt'
           when '2' then 'Weiterverweisung an Eheberatung, Schuldnerberatung, Kinder- und Jugendpsychotherapeuten, andere Einrichtungen'
           when '3' then 'Beratung in allgemeinen Fagen der Erziehung durch den ASD ( 16 Abs. 2 Nr. 2 SGB VIII)'
           when '4' then 'Hilfe zur Erziehung gem  27-35, 41 SGB VIII'
           when '5' then 'Eingliederungshilfe gem  35a SGB VIII'
           when '6' then 'Keine unmittelbar nachfolgende Hilfe gem  27-35, 41 SGB VIII bekannt'
      end,'') as "Nachfolgende Hilfe",

/* Freigabe und bergabe */

      isnull(case s.freigegeben 
           when '1' then 'ja'
           when '2' then 'nein'
      end,'') as "Freigabe",

      case s.uebergabeerfolgt
           when '1' then 'ja'
           else 'nein'
      end as "bergabe erfolgt"

from  n_vorgang v left join n_benutzer u on v.sachbearbeiter = u.lfdnr
                  inner join n_vorgbeteiligte b on v.vorgangsnummer = b.vorgang and b.beteiligtenart = 7
                  inner join n_adressen a on b.adresse = a.adressnummer
                  inner join n_personendaten p on b.adresse = p.zuordnungsnummer
                  inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                  inner join n_hzestatistik s on h.massnahme = s.massnahmennummer
                  inner join n_massnahme m on h.massnahme = m.massnahmennummer

where cast(s.berichtsjahr as integer) >= 2023

order by v.bereich, 
         a.nachname,
         a.vorname
